<?php
    /**
    *
    * copyright (c) 2013-2021 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    */

    class VisualizzatoreForm extends VisualizzatoreComponente {
        function __construct($db) {
            parent::__construct($db);
        }

        function generaContenutoSezione($dati) {
            $impostazioniForm         = parent::getDb()->leggiSingolaRiga("geec_form",$dati["idElemento"]);
            $impostazioniAspetto      = parent::getDb()->leggiSingolaRiga("geecD_impostazioni",1);
            $paginaRingraziamento     = parent::getDb()->leggiSingolaRiga("geecD_contenuti",$impostazioniForm["paginaRingraziamento"]);
            if($paginaRingraziamento) { // se la pagina ringraziamento è stata impostata calcola il link
                $linkPaginaRingraziamento = GeneratoreUrl::creaUrlContenuto($paginaRingraziamento, $impostazioniAspetto["ottimizzazioneUrl"], $impostazioniAspetto["urlPiattaforma"]);
            }
            else { 
                $linkPaginaRingraziamento = "";
            }
            
            echo "<div class=\"{$impostazioniForm["spazioOccupato"]}\">";
            $this->stampaSoloForm($impostazioniForm,$dati,$linkPaginaRingraziamento);
            echo"</div>";
        }
        
        function stampaSoloForm($impostazioniForm,$dati,$linkPaginaRingraziamento) {
            echo "<h2 class=\"separatore-inferiore text-center\"> {$impostazioniForm["nome"]} </h2>
                    <p class=\"mb-3\">I campi contrassegnati con <strong>*</strong> sono obbligatori</p>
                    <form name=\"form{$impostazioniForm["id"]}\" id=\"form{$impostazioniForm["id"]}\" class=\"mb-5\">";
                        $this->stampaElementiForm($dati,$impostazioniForm);
                        echo"<button type=\"button\" class=\"btn btn-lg btn-primary btn-block invia\" onclick=\"invia({$impostazioniForm["id"]},'{$impostazioniForm["spuntaPrivacy"]}','$linkPaginaRingraziamento')\">{$impostazioniForm["etichettaPulsante"]}</button>
                    </form>";
        }
        
        function stampaElementiForm($dati,$impostazioniForm) {
            $query = "SELECT * FROM geec_elementiForm WHERE idForm = {$dati["idElemento"]} ORDER BY posizione ASC";
            $ris   = parent::getDb()->eseguiQueryLettura($query);
            while($elemento = $ris->fetch_assoc()) {
                $campoObblicatorio = ($elemento["obbligatorio"]=="si") ? " *" : "";
                $stringaRequired   = ($elemento["obbligatorio"]=="si") ? " required" : "";
                if($elemento["tipo"]=="Testo") {
                    GeneratoreForm::stampaInputTestuale($elemento["nome"], $elemento["nome"], $elemento["etichetta"].$campoObblicatorio, $elemento["placeholder"],$elemento["valore"],$stringaRequired,true,"form-label-group");
                }
                else if($elemento["tipo"]=="Email") {
                    GeneratoreForm::stampaInputEmail($elemento["nome"], $elemento["nome"], $elemento["etichetta"].$campoObblicatorio, $elemento["placeholder"],$elemento["valore"],$stringaRequired,"form-label-group");
                }
                else if($elemento["tipo"]=="Area testo") {
                    GeneratoreForm::stampaAreaTesto($elemento["nome"], $elemento["nome"], $elemento["etichetta"].$campoObblicatorio,$elemento["placeholder"],$elemento["valore"],10,0,$stringaRequired,"form-label-group");
                }
                else if($elemento["tipo"]=="Password") {
                    GeneratoreForm::stampaInputPassword($elemento["nome"], $elemento["nome"], $elemento["etichetta"].$campoObblicatorio, $elemento["placeholder"],"form-label-group");
                }
                else if($elemento["tipo"]=="Tendina") {
                    $opzioniTendina = explode(",",$elemento["opzioni"]);
                    GeneratoreForm::stampaSelect($elemento["nome"], $elemento["nome"], $elemento["etichetta"].$campoObblicatorio, $opzioniTendina,$elemento["valore"], "form-group");
                }
                else if($elemento["tipo"]=="Checkbox") {
                    GeneratoreForm::stampaInputCheckbox($elemento["nome"], $elemento["nome"], $elemento["etichetta"].$campoObblicatorio, $elemento["valore"], "custom-control custom-checkbox my-3","custom-control-input", $stringaRequired);
                }
                else if($elemento["tipo"]=="Radio") {
                    GeneratoreForm::stampaInputCheckbox($elemento["nome"], $elemento["nome"], $elemento["etichetta"].$campoObblicatorio, $elemento["placeholder"],"form-label-group");
                }
                else if($elemento["tipo"]=="Data") {
                    GeneratoreForm::stampaInputData($elemento["nome"], $elemento["nome"], $elemento["etichetta"].$campoObblicatorio, $elemento["placeholder"],$elemento["valore"],$stringaRequired,"form-label-group");
                }
                else if($elemento["tipo"]=="Orario") {
                    GeneratoreForm::stampaInputOrario($elemento["nome"], $elemento["nome"], $elemento["etichetta"].$campoObblicatorio, $elemento["placeholder"],$elemento["valore"],$stringaRequired,"form-label-group");
                }
                else if($elemento["tipo"]=="Link pagina form") {
                    $linkPaginaForm = $_SERVER["REQUEST_URI"];
                    GeneratoreForm::stampaInputNascosto("Pagina web", $linkPaginaForm);
                }
            }
            
            if($impostazioniForm["spuntaPrivacy"]) {
                echo"<div class=\"custom-control custom-checkbox my-3 mr-sm-2\">
                    <input type=\"checkbox\" id=\"accettazioneTerminiCondizioni\" value=\"si\" class=\"custom-control-input\"> 
                    <label class=\"custom-control-label\" for=\"accettazioneTerminiCondizioni\">
                        Accetto le <a href=\"{$impostazioniForm["linkPrivacy"]}\" target=\"_blank\">Condizioni sulla privacy</a>
                    </label>
                </div>";
            }
        }
    }